# based on the "patch deployment" strategy in this comment:
# https://github.com/kubernetes/kubernetes/issues/13488#issuecomment-372532659
# requires jq

# $1 is a valid namespace
function refresh-all-pods(){
  ###声明时间变量,作为deployment的注解值###
  nowtime=$(date +%Y-%m-%d_%H-%M-%S)
  echo
  ###查找所有的deployment名称###
  DEPLOYMENT_LIST=$(kubectl -n $1 get deployment -o jsonpath="{.items[*].metadata.name}")
  echo "Refreshing pods in all Deployments"
  
  ###循环遍历所有的deployment###
  for deployment_name in $DEPLOYMENT_LIST ; do
  
    ###获取cn.aibianli.k8s.version注解的值###
    cn_aibianli_k8s_version=$(kubectl -n $1 get deployment "$deployment_name" -o jsonpath="{.spec.template.metadata.annotations.cn\.aibianli\.k8s\.version}")
	
	###如果注解存在或者有值,赋值为时间变量###
    if [[ -n "$cn_aibianli_k8s_version" ]]; then
      cn_aibianli_k8s_version="$nowtime"
	  
	###如果注解没有值###
    else
      continue;
    fi
	
	###需要执行的patch命令###
    patch_string="{\"spec\":{\"template\":{\"metadata\":{\"annotations\":{\"cn.aibianli.k8s.version\":\"$cn_aibianli_k8s_version\"}}}}}"
	###执行patch命令###
    kubectl -n $1 patch deployment $deployment_name -p $patch_string

  done
  echo
}

#refresh-all-pods $NAMESPACE

###更新default命名空间所有的deployment###
refresh-all-pods default
