#!/bin/bash

##dockerfile
#PROJECT 项目名
#projectname  projectversion projectport projectliveurl

workspace=$1
rprojectname=$2
#rprojectversion=`date "+%Y-%m-%d_%H-%M-%S"`
rprojectversion=$3
rprojectport=$4
rprojectliveurl=$5

###随机版本号###
randomversion=`date "+%Y-%m-%d_%H-%M-%S"`

###tomcat的镜像版本###
#tomcatdockerversion='tomcat:8.5.41-jre8'
tomcatdockerversion='tomcat:9-jdk11'

echo "脚本$0开始执行"








###如果项目的目录存在,执行自定义的文件模板###
if [ -d "/data/tomcat-k8s/tomcattemplatel/${rprojectname}" ]; then 

	###复制模板文件到构建目录###
	cp -rf /data/tomcat-k8s/tomcattemplatel/${rprojectname}/tomcat.df ${workspace}/target/
	cp -rf /data/tomcat-k8s/tomcattemplatel/${rprojectname}/tomcat.yaml ${workspace}/target/

###自定义的目录不存在,复制通用模板###
else 
	###复制模板文件到构建目录###
	cp -rf /data/tomcat-k8s/tomcattemplatel/tomcat.df ${workspace}/target/
	cp -rf /data/tomcat-k8s/tomcattemplatel/tomcat.yaml ${workspace}/target/


fi




###变量替换####
sed -i "s/projectname/${rprojectname}/g" ${workspace}/target/tomcat.df
sed -i "s/projectversion/${rprojectversion}/g" ${workspace}/target/tomcat.df
sed -i "s/tomcatdockerversion/${tomcatdockerversion}/g" ${workspace}/target/tomcat.df


sed -i "s/projectname/${rprojectname}/g" ${workspace}/target/tomcat.yaml
sed -i "s/projectversion/${rprojectversion}/g" ${workspace}/target/tomcat.yaml

sed -i "s/randomversion/${randomversion}/g" ${workspace}/target/tomcat.yaml

sed -i "s/projectport/${rprojectport}/g" ${workspace}/target/tomcat.yaml
sed -i "s@projectliveurl@${rprojectliveurl}@g" ${workspace}/target/tomcat.yaml



###进入构建目录###
cd ${workspace}/target/

###构建根据dockerfile构建docker镜像####
docker build -t 10.98.239.102:5000/${rprojectname}:${randomversion} -f tomcat.df .
#docker build -t ${rprojectname}:${randomversion} -f tomcat.df .


###把docker镜像推送到镜像仓库,k8s才能使用###
docker push 10.98.239.102:5000/${rprojectname}:${randomversion}
#docker push ${rprojectname}:${randomversion}


export KUBECONFIG=/etc/kubernetes/admin.conf 

##kubectl apply -f ${workspace}/target/tomcat.yaml

###删除现有的pod###
#kubectl delete -f ${workspace}/target/tomcat.yaml
###sleep 3
###创建新的pod###
#kubectl create -f ${workspace}/target/tomcat.yaml

###滚动更新deployment###
kubectl apply -f ${workspace}/target/tomcat.yaml


