package com.mzywx.rpc.grpcimpl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.protobuf.ByteString;
import com.mzywx.rpc.grpcauto.GrpcCommonServiceGrpc;
import com.mzywx.rpc.grpcauto.GrpcCommonServiceGrpc.GrpcCommonServiceBlockingStub;
import com.mzywx.rpc.grpcauto.Request;
import com.mzywx.rpc.grpcauto.Response;
import com.mzywx.rpc.util.JacksonRPCSerializeUtils;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;

/**
 * Grpc的客户端
 * 
 * @author caomei
 *
 */

public class GrpcClient {
	private static final Logger logger = LoggerFactory.getLogger(GrpcClient.class);
	// 缓存 entity的字段信息
	private static Map<String, GrpcCommonServiceBlockingStub> staticBlockingStubmap = new ConcurrentHashMap<>();

	/**
	 * 处理 gRPC 请求
	 */
	public static GrpcResponse handle(String rpcHost, Integer rpcPort, GrpcRequest grpcRequest) {

		ByteString bytes = JacksonRPCSerializeUtils.serialize(grpcRequest);

		Request request = Request.newBuilder().setRequest(bytes).build();
		Response response;
		try {
			response = getBlockingStub(rpcHost, rpcPort).handle(request);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			response = getBlockingStub(rpcHost, rpcPort).handle(request);
		}
		return JacksonRPCSerializeUtils.deserialize(response);
	}

	/**
	 * 获取grpc连接
	 * 
	 * @param rpcHost
	 * @param rpcPort
	 * @return
	 */
	public static GrpcCommonServiceBlockingStub getBlockingStub(String rpcHost, Integer rpcPort) {
		if (rpcHost == null || "".equals(rpcHost) || rpcPort == null || rpcPort <= 0) {
			return null;
		}

		String key = rpcHost + ":" + rpcPort;
		GrpcCommonServiceBlockingStub grpcCommonServiceBlockingStub = staticBlockingStubmap.get(key);

		if (grpcCommonServiceBlockingStub != null) {
			return grpcCommonServiceBlockingStub;
		}

		ManagedChannel channel = ManagedChannelBuilder.forAddress(rpcHost, rpcPort).usePlaintext().build();
		GrpcCommonServiceBlockingStub blockingStub = GrpcCommonServiceGrpc.newBlockingStub(channel);

		staticBlockingStubmap.put(key, blockingStub);
		return blockingStub;

	}

}
