package com.mzywx.rpc.grpcimpl;

import java.io.Serializable;

/**
 * 接受请求,所有的请求都封装成springbean的调用. 序列化成二进制,然后再经过grpc传输
 * 
 * @author caomei
 *
 */
public class GrpcRequest implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 接口
	 */
	private String clazz;

	/**
	 * spring 的bean Name
	 */
	private String beanName;

	/**
	 * 方法
	 */
	private String method;

	/**
	 * service 方法参数
	 */
	private Object[] args;

	public String getClazz() {
		return clazz;
	}

	public String getBeanName() {
		return beanName;
	}

	public void setBeanName(String beanName) {
		this.beanName = beanName;
	}

	public String getMethod() {
		return method;
	}

	public Object[] getArgs() {
		return args;
	}

	public void setClazz(String clazz) {
		this.clazz = clazz;
	}

	public void setMethod(String method) {
		this.method = method;
	}

	public void setArgs(Object[] args) {
		this.args = args;
	}

}
