package com.mzywx.rpc.springbind;

import java.lang.reflect.Method;
import java.util.Arrays;

import org.springframework.cglib.proxy.InvocationHandler;

import com.mzywx.rpc.grpcimpl.GrpcClient;
import com.mzywx.rpc.grpcimpl.GrpcException;
import com.mzywx.rpc.grpcimpl.GrpcRequest;
import com.mzywx.rpc.grpcimpl.GrpcResponse;

/**
 * 代理grpc的service服务
 * 
 * @author caomei
 *
 * @param <T>
 */
public class GrpcServiceProxy<T> implements InvocationHandler {

	private Class<T> grpcService;

	// private Object invoker;

	private String rpcHost;

	private Integer rpcPort;

	String beanName;

	public GrpcServiceProxy(Class<T> grpcService, String rpcHost, Integer rpcPort, String beanName) {
		this.grpcService = grpcService;
		// this.invoker = invoker;
		this.rpcHost = rpcHost;
		this.rpcPort = rpcPort;
		this.beanName = beanName;
	}

	@Override
	public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
		String methodName = method.getName();
		String className = grpcService.getName();

		GrpcRequest grpcRequest = new GrpcRequest();
		grpcRequest.setClazz(className);
		grpcRequest.setMethod(methodName);
		grpcRequest.setArgs(args);
		grpcRequest.setBeanName(className);

		// grpc客户端.发起请求
		GrpcResponse grpcResponse = GrpcClient.handle(rpcHost, rpcPort,
				grpcRequest);
		// 处理异常
		if (500 == grpcResponse.getStatus()) {
			Throwable throwable = grpcResponse.getException();
			GrpcException exception = new GrpcException(throwable.getClass().getName() + ": " + throwable.getMessage());
			StackTraceElement[] exceptionStackTrace = exception.getStackTrace();
			StackTraceElement[] responseStackTrace = grpcResponse.getStackTrace();
			StackTraceElement[] allStackTrace = Arrays.copyOf(exceptionStackTrace,
					exceptionStackTrace.length + responseStackTrace.length);
			System.arraycopy(responseStackTrace, 0, allStackTrace, exceptionStackTrace.length,
					responseStackTrace.length);
			exception.setStackTrace(allStackTrace);
			throw exception;
		}
		// 返回结果
		return grpcResponse.getResult();
	}

}
