package com.mzywx.rpc.annotation;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;

/**
 * 标识接口可能会被rpc代理,所有的接口都加上就可以了,根据路径规则找默认的实现文件,
 * 如果找到就初始化本地,如果找不到就调用远程RPC,目前只支持一个bean,按照类型装配
 * 
 * @author caomei
 *
 */

@Documented
@Inherited
@Retention(RUNTIME)
public @interface RpcServiceAnnotation {

    /**
	 * rpc的主机地址
	 * 
	 * @return
	 */
	String rpcHost() default "";

	/**
	 * rpc的端口
	 * 
	 * @return
	 */
	int rpcPort() default -1;
	
	/**
	 * springBean 的beanName,目前只支持一个bean,暂时无用
	 * 
	 * @return
	 */
	String beanName() default "";
	


}