package com.mzywx.rpc.grpcimpl;

import java.io.Serializable;

/**
 * 封装返回的对象. 序列化成二进制,然后再经过grpc传输
 * 
 * @author caomei
 *
 */
public class GrpcResponse implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 响应状态
	 */
	private int status;

	/**
	 * 信息提示
	 */
	private String message;

	/**
	 * 返回结果
	 */
	private Object result;

	/**
	 * 服务端异常
	 */
	private Throwable exception;

	/**
	 * 异常堆栈信息
	 */
	private StackTraceElement[] stackTrace;

	void error(String message, Throwable exception, StackTraceElement[] stackTrace) {
		this.status = 500;
		this.message = message;
		this.exception = exception;
		this.stackTrace = stackTrace;
	}

	void success(Object result) {
		this.status = 200;
		this.result = result;
	}

	public int getStatus() {
		return status;
	}

	public String getMessage() {
		return message;
	}

	public Object getResult() {
		return result;
	}

	public Throwable getException() {
		return exception;
	}

	public StackTraceElement[] getStackTrace() {
		return stackTrace;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public void setResult(Object result) {
		this.result = result;
	}

	public void setException(Throwable exception) {
		this.exception = exception;
	}

	public void setStackTrace(StackTraceElement[] stackTrace) {
		this.stackTrace = stackTrace;
	}

}
