package com.mzywx.rpc.util;

import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.protobuf.ByteString;
import com.mzywx.rpc.grpcauto.Request;
import com.mzywx.rpc.grpcauto.Response;
import com.mzywx.rpc.grpcimpl.GrpcRequest;
import com.mzywx.rpc.grpcimpl.GrpcResponse;

/**
 * FastJSON 序列化/反序列化工具
 */
public class JacksonRPCSerializeUtils {
	private static ObjectMapper mapper = null;
	private static final Logger logger = LoggerFactory.getLogger(JacksonRPCSerializeUtils.class);
	static {
		mapper = new ObjectMapper();
		mapper.setLocale(Locale.CHINA);
		// 为 null 的不转换
		// this.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
		mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
		// 支持 属性不对应
		mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
		// 为bean 为null时不报异常
		mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
		// 键 支持 不带 双引号 ""
		mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
		// 设置日期格式
		// mapper.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
	}

	public static ByteString serialize(GrpcResponse grpcResponse) {
		try {
			return ByteString.copyFrom(mapper.writeValueAsBytes(grpcResponse));
		} catch (JsonProcessingException e) {
			logger.error(e.getMessage(), e);
			return null;
		}
	}

	public static ByteString serialize(GrpcRequest grpcRequest) {

		try {
			return ByteString.copyFrom(mapper.writeValueAsBytes(grpcRequest));
		} catch (JsonProcessingException e) {
			logger.error(e.getMessage(), e);
			return null;
		}

	}

	public static GrpcRequest deserialize(Request request) {
		byte[] bytes = request.getRequest().toByteArray();
		try {
			return mapper.readValue(bytes, GrpcRequest.class);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			return null;
		}
	}

	public static GrpcResponse deserialize(Response response) {
		byte[] bytes = response.getResponse().toByteArray();
		try {
			return mapper.readValue(bytes, GrpcResponse.class);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			return null;
		}
	}

}
