package com.mzywx.rpc.grpcimpl;

import java.lang.reflect.Method;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

import com.google.protobuf.ByteString;
import com.mzywx.rpc.grpcauto.GrpcCommonServiceGrpc;
import com.mzywx.rpc.grpcauto.Response;
import com.mzywx.rpc.util.JacksonRPCSerializeUtils;

/**
 * 集成自动产生的java类,自定义自己的实现.总体思路是
 * 请求的class,方法,和参数做成二进制,通过grpc传递,实际是二次序列化,对性能有损耗,但是方便......
 * 
 * 
 * @author caomei
 *
 */
public class CommonGrpcService extends GrpcCommonServiceGrpc.GrpcCommonServiceImplBase {

	private ApplicationContext applicationContext = null;

	public CommonGrpcService(ApplicationContext applicationContext) {

		this.applicationContext = applicationContext;
	}

	/**
	 * <pre>
	 * 处理请求
	 * </pre>
	 */
	@Override
	public void handle(com.mzywx.rpc.grpcauto.Request request,
			io.grpc.stub.StreamObserver<com.mzywx.rpc.grpcauto.Response> responseObserver) {

		// 把请求反序列化成正常对象,GrpcRequest
		GrpcRequest grpcRequest = JacksonRPCSerializeUtils.deserialize(request);
		// 初始化需要返回的对象
		GrpcResponse grpcResponse = new GrpcResponse();
		try {
			// String beanName = grpcRequest.getBeanName();
			// 需要调用的类
			String className = grpcRequest.getClazz();
			// 获取springbean
			Object bean = getBean(Class.forName(className));
			// 获取获取参数
			Object[] args = grpcRequest.getArgs();
			// 获取参数类型
			Class[] argsTypes = getParameterTypes(args);
			// 找到类的方法
			// Method matchingMethod =
			// MethodUtils.getMatchingMethod(Class.forName(className),
			// grpcRequest.getMethod(),argsTypes);
			// FastClass serviceFastClass = FastClass.create(bean.getClass());
			// FastMethod serviceFastMethod = serviceFastClass.getMethod(matchingMethod);
			// 找到类的方法
			Method method = bean.getClass().getMethod(grpcRequest.getMethod(), argsTypes);

			// 执行service的方法
			Object result = method.invoke(bean, args);
			// 设置结果状态
			grpcResponse.success(result);
		} catch (Exception exception) {
			String message = exception.getClass().getName() + ": " + exception.getMessage();
			grpcResponse.error(message, exception, exception.getStackTrace());
		}
		// 序列化需要返回的结果
		ByteString bytes = JacksonRPCSerializeUtils.serialize(grpcResponse);
		// 封装成grpc传递的对象
		Response response = Response.newBuilder().setResponse(bytes).build();
		// grpc下一步处理
		responseObserver.onNext(response);
		// 完成传输
		responseObserver.onCompleted();

	}

	/**
	 * 获取 Service Bean
	 */
	private Object getBean(Class clazz) throws NoSuchBeanDefinitionException {

		try {
			Object bean = applicationContext.getBean(clazz);
			return bean;
		} catch (BeansException e) {
			throw new NoSuchBeanDefinitionException(clazz);
		}
	}

	private Object getBeanByName(String beanName) {

		try {
			Object bean = applicationContext.getBean(beanName);
			return bean;
		} catch (BeansException e) {
			return null;
		}
	}

	/**
	 * 获取参数类型
	 */
	private Class[] getParameterTypes(Object[] parameters) {
		if (parameters == null) {
			return null;
		}
		Class[] clazzArray = new Class[parameters.length];
		for (int i = 0; i < parameters.length; i++) {
			clazzArray[i] = parameters[i].getClass();

		}
		return clazzArray;
	}

}
