package com.mzywx.rpc.grpcimpl;

import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;

import com.mzywx.rpc.springbind.RpcStaticVariable;

import io.grpc.Server;
import io.grpc.ServerBuilder;

/**
 * gRPC Server管理,启动grpcServer
 */
@Component
public class GrpcServer implements DisposableBean {
	private static final Logger logger = LoggerFactory.getLogger(GrpcServer.class);

	private CommonGrpcService commonGrpcService;

	private Server server;

	public GrpcServer() {

	}

	public GrpcServer(CommonGrpcService commonGrpcService) {
		this.commonGrpcService = commonGrpcService;
	}

	/**
	 * 启动服务
	 * 
	 * @throws Exception 异常
	 */
	public void start() throws Exception {
		server = ServerBuilder.forPort(RpcStaticVariable.rpcPort).addService(commonGrpcService).build().start();
		startDaemonAwaitThread();
	}

	/**
	 * 销毁
	 */
	@Override
	public void destroy() {
		Optional.ofNullable(server).ifPresent(Server::shutdown);
	}

	private void startDaemonAwaitThread() {
		Thread awaitThread = new Thread(() -> {

			try {
				GrpcServer.this.server.awaitTermination();
			} catch (InterruptedException e) {
				logger.error(e.getMessage(), e);
			}

		});
		awaitThread.setDaemon(false);
		awaitThread.start();
	}

}