package org.apache.shardingsphere.spi.database;

import org.apache.shardingsphere.core.database.DatabaseTypes;

import java.util.Collection;
import java.util.Collections;

/**
 *
 * 扩展BranchDatabaseType,实现达梦数据库的DMDatabaseType
 * DatabaseTypes的静态方法,通过SPI加载,需要在 META-INF/services/org.apache.shardingsphere.spi.database.DatabaseType中配置全路径
 *
 * @author 475966480@qq.com
 */
public final class DMDatabaseType implements BranchDatabaseType {
    public DMDatabaseType() {
    }

    //需要和驱动url中的jdbc:dm 保持一致,不区分大小写,这里用DM
    public String getName() {
        return "DM";
    }

    public Collection<String> getJdbcUrlPrefixAlias() {
        return Collections.emptyList();
    }

    //达梦数据库的数据源元数据
    public DMDataSourceMetaData getDataSourceMetaData(String url, String username) {
        return new DMDataSourceMetaData(url);
    }

    //作为MySQL的子集,sql解析等操作使用MySQL的实现
    @Override
    public DatabaseType getTrunkDatabaseType() {
        return DatabaseTypes.getActualDatabaseType("MySQL");
    }
}
