/*
 * Decompiled with CFR 0.152.
 */
package com.danga.MemCached;

import com.danga.MemCached.LineInputStream;
import com.schooner.MemCached.SchoonerSockIOPool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SockIOPool {
    private static Logger log = LoggerFactory.getLogger(SockIOPool.class);
    private static final Integer ZERO = new Integer(0);
    private int poolMultiplier = 3;
    private int minConn = 5;
    private int maxConn = 100;
    private long maxIdle = 300000L;
    private long maxBusyTime = 30000L;
    private int socketTO = 3000;
    private int socketConnectTO = 3000;
    private boolean failover = true;
    private boolean failback = true;
    private boolean nagle = false;
    private final ReentrantLock hostDeadLock = new ReentrantLock();
    private Map<String, Date> hostDead;
    private Map<String, Long> hostDeadDur;
    private Map<String, Map<SockIO, Long>> availPool;
    private Map<String, Map<SockIO, Long>> busyPool;
    private Map<SockIO, Integer> deadPool;
    private SchoonerSockIOPool schoonerSockIOPool;
    public static final int NATIVE_HASH = 0;
    public static final int OLD_COMPAT_HASH = 1;
    public static final int NEW_COMPAT_HASH = 2;
    public static final int CONSISTENT_HASH = 3;
    public static final long MAX_RETRY_DELAY = 600000L;

    protected SockIOPool() {
    }

    public static synchronized SockIOPool getInstance(String string) {
        SockIOPool sockIOPool = new SockIOPool();
        sockIOPool.schoonerSockIOPool = SchoonerSockIOPool.getInstance(string);
        return sockIOPool;
    }

    public static SockIOPool getInstance(boolean bl) {
        SockIOPool sockIOPool = new SockIOPool();
        sockIOPool.schoonerSockIOPool = SchoonerSockIOPool.getInstance(bl);
        return sockIOPool;
    }

    public static SockIOPool getInstance(String string, boolean bl) {
        SockIOPool sockIOPool = new SockIOPool();
        sockIOPool.schoonerSockIOPool = SchoonerSockIOPool.getInstance(string, bl);
        return sockIOPool;
    }

    public static SockIOPool getInstance() {
        SockIOPool sockIOPool = new SockIOPool();
        sockIOPool.schoonerSockIOPool = SchoonerSockIOPool.getInstance("default");
        return sockIOPool;
    }

    public void setServers(String[] stringArray) {
        this.schoonerSockIOPool.setServers(stringArray);
    }

    public String[] getServers() {
        return this.schoonerSockIOPool.getServers();
    }

    public void setWeights(Integer[] integerArray) {
        this.schoonerSockIOPool.setWeights(integerArray);
    }

    public Integer[] getWeights() {
        return this.schoonerSockIOPool.getWeights();
    }

    public void setInitConn(int n) {
        this.schoonerSockIOPool.setInitConn(n);
    }

    public int getInitConn() {
        return this.schoonerSockIOPool.getInitConn();
    }

    public void setMinConn(int n) {
        this.schoonerSockIOPool.setMinConn(n);
    }

    public int getMinConn() {
        return this.schoonerSockIOPool.getMinConn();
    }

    public void setMaxConn(int n) {
        this.schoonerSockIOPool.setMaxConn(n);
    }

    public int getMaxConn() {
        return this.schoonerSockIOPool.getMaxConn();
    }

    public void setMaxBusyTime(long l) {
        this.schoonerSockIOPool.setMaxBusyTime(l);
    }

    public long getMaxBusy() {
        return this.schoonerSockIOPool.getMaxBusy();
    }

    public void setSocketTO(int n) {
        this.schoonerSockIOPool.setSocketTO(n);
    }

    public int getSocketTO() {
        return this.schoonerSockIOPool.getSocketTO();
    }

    public void setSocketConnectTO(int n) {
        this.schoonerSockIOPool.setSocketConnectTO(n);
    }

    public int getSocketConnectTO() {
        return this.schoonerSockIOPool.getSocketTO();
    }

    public void setMaxIdle(long l) {
        this.schoonerSockIOPool.setMaxIdle(l);
    }

    public long getMaxIdle() {
        return this.schoonerSockIOPool.getMaxIdle();
    }

    public void setMaintSleep(long l) {
        this.schoonerSockIOPool.setMaintSleep(l);
    }

    public long getMaintSleep() {
        return this.schoonerSockIOPool.getMaintSleep();
    }

    public void setFailover(boolean bl) {
        this.schoonerSockIOPool.setFailover(bl);
    }

    public boolean getFailover() {
        return this.schoonerSockIOPool.getFailover();
    }

    public void setFailback(boolean bl) {
        this.schoonerSockIOPool.setFailback(bl);
    }

    public boolean getFailback() {
        return this.schoonerSockIOPool.getFailback();
    }

    public void setAliveCheck(boolean bl) {
        this.schoonerSockIOPool.setAliveCheck(bl);
    }

    public boolean getAliveCheck() {
        return this.schoonerSockIOPool.getAliveCheck();
    }

    public void setNagle(boolean bl) {
        this.schoonerSockIOPool.setNagle(bl);
    }

    public boolean getNagle() {
        return this.schoonerSockIOPool.getNagle();
    }

    public void setHashingAlg(int n) {
        this.schoonerSockIOPool.setHashingAlg(n);
    }

    public int getHashingAlg() {
        return this.schoonerSockIOPool.getHashingAlg();
    }

    public void initialize() {
        this.schoonerSockIOPool.initialize();
    }

    public boolean isInitialized() {
        return this.schoonerSockIOPool.isInitialized();
    }

    public String getHost(String string) {
        return this.schoonerSockIOPool.getHost(string);
    }

    public String getHost(String string, Integer n) {
        return this.schoonerSockIOPool.getHost(string, n);
    }

    public void shutDown() {
        this.schoonerSockIOPool.shutDown();
    }

    public void setBufferSize(int n) {
        this.schoonerSockIOPool.setBufferSize(n);
    }

    public int getBufferSize() {
        return this.schoonerSockIOPool.getBufferSize();
    }

    public SockIO getSock(String string) {
        return this.schoonerSockIOPool.getSock(string);
    }

    public SockIO getSock(String string, Integer n) {
        return this.schoonerSockIOPool.getSock(string, n);
    }

    public SockIO getConnection(String string) {
        return this.schoonerSockIOPool.getConnection(string);
    }

    private void checkIn(SockIO sockIO) {
        this.checkIn(sockIO, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIn(SockIO sockIO, boolean bl) {
        String string = sockIO.getHost();
        if (log.isDebugEnabled()) {
            log.debug("++++ calling check-in on socket: " + sockIO.toString() + " for host: " + string);
        }
        SockIOPool sockIOPool = this;
        synchronized (sockIOPool) {
            if (log.isDebugEnabled()) {
                log.debug("++++ removing socket (" + sockIO.toString() + ") from busy pool for host: " + string);
            }
            this.removeSocketFromPool(this.busyPool, string, sockIO);
            if (sockIO.isConnected() && bl) {
                if (log.isDebugEnabled()) {
                    log.debug("++++ returning socket (" + sockIO.toString() + " to avail pool for host: " + string);
                }
                this.addSocketToPool(this.availPool, string, sockIO);
            } else {
                this.deadPool.put(sockIO, ZERO);
                sockIO = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SockIO createSocket(String string) {
        long l;
        Date date;
        SockIO sockIO = null;
        this.hostDeadLock.lock();
        try {
            if (this.failover && this.failback && this.hostDead.containsKey(string) && this.hostDeadDur.containsKey(string)) {
                date = this.hostDead.get(string);
                l = this.hostDeadDur.get(string);
                if (date.getTime() + l > System.currentTimeMillis()) {
                    SockIO sockIO2 = null;
                    return sockIO2;
                }
            }
        }
        finally {
            this.hostDeadLock.unlock();
        }
        try {
            sockIO = new SockIO(this, string, this.socketTO, this.socketConnectTO, this.nagle);
            if (!sockIO.isConnected()) {
                if (log.isErrorEnabled()) {
                    log.error("++++ failed to get SockIO obj for: " + string + " -- new socket is not connected");
                }
                this.deadPool.put(sockIO, ZERO);
                sockIO = null;
            }
        }
        catch (Exception exception) {
            if (log.isErrorEnabled()) {
                log.error("++++ failed to get SockIO obj for: " + string);
                log.error(exception.getMessage(), (Throwable)exception);
            }
            sockIO = null;
        }
        this.hostDeadLock.lock();
        try {
            if (sockIO == null) {
                date = new Date();
                this.hostDead.put(string, date);
                long l2 = l = this.hostDeadDur.containsKey(string) ? this.hostDeadDur.get(string) * 2L : 1000L;
                if (l > 600000L) {
                    l = 600000L;
                }
                this.hostDeadDur.put(string, new Long(l));
                if (log.isDebugEnabled()) {
                    log.debug("++++ ignoring dead host: " + string + " for " + l + " ms");
                }
                this.clearHostFromPool(this.availPool, string);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("++++ created socket (" + sockIO.toString() + ") for host: " + string);
                }
                if (this.hostDead.containsKey(string) || this.hostDeadDur.containsKey(string)) {
                    this.hostDead.remove(string);
                    this.hostDeadDur.remove(string);
                }
            }
        }
        finally {
            this.hostDeadLock.unlock();
        }
        return sockIO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selfMaint() {
        if (log.isDebugEnabled()) {
            log.debug("++++ Starting self maintenance....");
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Object object2 = this;
        synchronized (object2) {
            for (String iterator2 : this.availPool.keySet()) {
                Map<SockIO, Long> map = this.availPool.get(iterator2);
                if (log.isDebugEnabled()) {
                    log.debug("++++ Size of avail pool for host (" + iterator2 + ") = " + map.size());
                }
                if (map.size() >= this.minConn) continue;
                int n = this.minConn - map.size();
                hashMap.put(iterator2, n);
            }
        }
        object2 = new HashMap();
        for (String string : hashMap.keySet()) {
            SockIO sockIO;
            Integer n = (Integer)hashMap.get(string);
            if (log.isDebugEnabled()) {
                log.debug("++++ Need to create " + n + " new sockets for pool for host: " + string);
            }
            HashSet<SockIO> hashSet = new HashSet<SockIO>(n);
            for (int i = 0; i < n && (sockIO = this.createSocket(string)) != null; ++i) {
                hashSet.add(sockIO);
            }
            object2.put(string, hashSet);
        }
        Set<SockIO> set = this;
        synchronized (set) {
            for (String string : object2.keySet()) {
                Set set2 = (Set)object2.get(string);
                for (SockIO sockIO : set2) {
                    this.addSocketToPool(this.availPool, string, sockIO);
                }
            }
            for (String string : this.availPool.keySet()) {
                int n;
                Map<SockIO, Long> map = this.availPool.get(string);
                if (log.isDebugEnabled()) {
                    log.debug("++++ Size of avail pool for host (" + string + ") = " + map.size());
                }
                if (map.size() <= this.maxConn) continue;
                int n2 = map.size() - this.maxConn;
                int n3 = n = n2 <= this.poolMultiplier ? n2 : n2 / this.poolMultiplier;
                if (log.isDebugEnabled()) {
                    log.debug("++++ need to remove " + n + " spare sockets for pool for host: " + string);
                }
                Iterator<SockIO> iterator = map.keySet().iterator();
                while (iterator.hasNext() && n > 0) {
                    SockIO sockIO = iterator.next();
                    long l = map.get(sockIO);
                    if (l + this.maxIdle >= System.currentTimeMillis()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("+++ removing stale entry from pool as it is past its idle timeout and pool is over max spare");
                    }
                    this.deadPool.put(sockIO, ZERO);
                    iterator.remove();
                    --n;
                }
            }
            for (String string : this.busyPool.keySet()) {
                Map<SockIO, Long> map = this.busyPool.get(string);
                if (log.isDebugEnabled()) {
                    log.debug("++++ Size of busy pool for host (" + string + ")  = " + map.size());
                }
                Iterator<SockIO> iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    SockIO sockIO = iterator.next();
                    long l = map.get(sockIO);
                    if (l + this.maxBusyTime >= System.currentTimeMillis()) continue;
                    if (log.isErrorEnabled()) {
                        log.error("+++ removing potentially hung connection from busy pool ... socket in pool for " + (System.currentTimeMillis() - l) + "ms");
                    }
                    this.deadPool.put(sockIO, ZERO);
                    iterator.remove();
                }
            }
        }
        Map<SockIO, Integer> map = this.deadPool;
        synchronized (map) {
            set = this.deadPool.keySet();
            this.deadPool = new IdentityHashMap<SockIO, Integer>();
        }
        for (SockIO sockIO : set) {
            block30: {
                try {
                    sockIO.trueClose(false);
                }
                catch (Exception exception) {
                    if (!log.isErrorEnabled()) break block30;
                    log.error("++++ failed to close SockIO obj from deadPool");
                    log.error(exception.getMessage(), (Throwable)exception);
                }
            }
            Object var5_23 = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("+++ ending self maintenance.");
        }
    }

    protected void addSocketToPool(Map<String, Map<SockIO, Long>> map, String string, SockIO sockIO) {
        Map<Object, Object> map2;
        if (map.containsKey(string) && (map2 = map.get(string)) != null) {
            map2.put(sockIO, new Long(System.currentTimeMillis()));
            return;
        }
        map2 = new IdentityHashMap();
        map2.put(sockIO, new Long(System.currentTimeMillis()));
        map.put(string, map2);
    }

    protected void removeSocketFromPool(Map<String, Map<SockIO, Long>> map, String string, SockIO sockIO) {
        Map<SockIO, Long> map2;
        if (map.containsKey(string) && (map2 = map.get(string)) != null) {
            map2.remove(sockIO);
        }
    }

    protected void clearHostFromPool(Map<String, Map<SockIO, Long>> map, String string) {
        Map<SockIO, Long> map2;
        if (map.containsKey(string) && (map2 = map.get(string)) != null && map2.size() > 0) {
            Iterator<SockIO> iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                SockIO sockIO;
                block4: {
                    sockIO = iterator.next();
                    try {
                        sockIO.trueClose();
                    }
                    catch (IOException iOException) {
                        if (!log.isErrorEnabled()) break block4;
                        log.error("++++ failed to close socket: " + iOException.getMessage());
                    }
                }
                iterator.remove();
                sockIO = null;
            }
        }
    }

    protected static class MaintThread
    extends Thread {
        private SockIOPool pool;
        private long interval = 3000L;
        private boolean stopThread = false;
        private boolean running;

        protected MaintThread(SockIOPool sockIOPool) {
            this.pool = sockIOPool;
            this.setDaemon(true);
            this.setName("MaintThread");
        }

        public void setInterval(long l) {
            this.interval = l;
        }

        public boolean isRunning() {
            return this.running;
        }

        public void stopThread() {
            this.stopThread = true;
            this.interrupt();
        }

        public void run() {
            this.running = true;
            while (!this.stopThread) {
                try {
                    Thread.sleep(this.interval);
                    if (!this.pool.isInitialized()) continue;
                    this.pool.selfMaint();
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
            this.running = false;
        }
    }

    public static class SockIO
    implements LineInputStream {
        private static Logger log = LoggerFactory.getLogger(SockIO.class);
        private SockIOPool pool;
        private String host;
        private Socket sock;
        private DataInputStream in;
        private BufferedOutputStream out;

        public SockIO(SockIOPool sockIOPool, String string, int n, int n2, int n3, boolean bl) throws IOException, UnknownHostException {
            this.pool = sockIOPool;
            this.sock = SockIO.getSocket(string, n, n3);
            if (n2 >= 0) {
                this.sock.setSoTimeout(n2);
            }
            this.sock.setTcpNoDelay(bl);
            this.in = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
            this.host = string + ":" + n;
        }

        public SockIO(SockIOPool sockIOPool, String string, int n, int n2, boolean bl) throws IOException, UnknownHostException {
            if (sockIOPool == null) {
                return;
            }
            this.pool = sockIOPool;
            String[] stringArray = string.split(":");
            this.sock = SockIO.getSocket(stringArray[0], Integer.parseInt(stringArray[1]), n2);
            if (n >= 0) {
                this.sock.setSoTimeout(n);
            }
            this.sock.setTcpNoDelay(bl);
            this.in = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
            this.out = new BufferedOutputStream(this.sock.getOutputStream());
            this.host = string;
        }

        protected static Socket getSocket(String string, int n, int n2) throws IOException {
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.socket().connect(new InetSocketAddress(string, n), n2);
            return socketChannel.socket();
        }

        public SocketChannel getChannel() {
            return this.sock.getChannel();
        }

        public String getHost() {
            return this.host;
        }

        public void trueClose() throws IOException {
            this.trueClose(true);
        }

        public void trueClose(boolean bl) throws IOException {
            if (log.isDebugEnabled()) {
                log.debug("++++ Closing socket for real: " + this.toString());
            }
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    if (log.isErrorEnabled()) {
                        log.error("++++ error closing input stream for socket: " + this.toString() + " for host: " + this.getHost());
                        log.error(iOException.getMessage(), (Throwable)iOException);
                    }
                    stringBuilder.append("++++ error closing input stream for socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    stringBuilder.append(iOException.getMessage());
                    bl2 = true;
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    if (log.isErrorEnabled()) {
                        log.error("++++ error closing output stream for socket: " + this.toString() + " for host: " + this.getHost());
                        log.error(iOException.getMessage(), (Throwable)iOException);
                    }
                    stringBuilder.append("++++ error closing output stream for socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    stringBuilder.append(iOException.getMessage());
                    bl2 = true;
                }
            }
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                    if (log.isErrorEnabled()) {
                        log.error("++++ error closing socket: " + this.toString() + " for host: " + this.getHost());
                        log.error(iOException.getMessage(), (Throwable)iOException);
                    }
                    stringBuilder.append("++++ error closing socket: " + this.toString() + " for host: " + this.getHost() + "\n");
                    stringBuilder.append(iOException.getMessage());
                    bl2 = true;
                }
            }
            if (bl && this.sock != null) {
                this.pool.checkIn(this, false);
            }
            this.in = null;
            this.out = null;
            this.sock = null;
            if (bl2) {
                throw new IOException(stringBuilder.toString());
            }
        }

        public void close() {
            if (log.isDebugEnabled()) {
                log.debug("++++ marking socket (" + this.toString() + ") as closed and available to return to avail pool");
            }
            this.pool.checkIn(this);
        }

        protected boolean isConnected() {
            return this.sock != null && this.sock.isConnected();
        }

        public boolean isAlive() {
            if (!this.isConnected()) {
                return false;
            }
            try {
                this.write("version\r\n".getBytes());
                this.flush();
                this.readLine();
            }
            catch (IOException iOException) {
                return false;
            }
            return true;
        }

        public String readLine() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                if (log.isErrorEnabled()) {
                    log.error("++++ attempting to read from closed socket");
                }
                throw new IOException("++++ attempting to read from closed socket");
            }
            byte[] byArray = new byte[1];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            boolean bl = false;
            while (this.in.read(byArray, 0, 1) != -1) {
                if (byArray[0] == 13) {
                    bl = true;
                } else if (bl) {
                    if (byArray[0] == 10) break;
                    bl = false;
                }
                byteArrayOutputStream.write(byArray, 0, 1);
            }
            if (byteArrayOutputStream == null || byteArrayOutputStream.size() <= 0) {
                throw new IOException("++++ Stream appears to be dead, so closing it down");
            }
            return byteArrayOutputStream.toString().trim();
        }

        public void clearEOL() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                if (log.isErrorEnabled()) {
                    log.error("++++ attempting to read from closed socket");
                }
                throw new IOException("++++ attempting to read from closed socket");
            }
            byte[] byArray = new byte[1];
            boolean bl = false;
            while (this.in.read(byArray, 0, 1) != -1) {
                if (byArray[0] == 13) {
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                if (byArray[0] == 10) break;
                bl = false;
            }
        }

        public int read(byte[] byArray) throws IOException {
            int n;
            int n2;
            if (this.sock == null || !this.sock.isConnected()) {
                if (log.isErrorEnabled()) {
                    log.error("++++ attempting to read from closed socket");
                }
                throw new IOException("++++ attempting to read from closed socket");
            }
            for (n = 0; n < byArray.length; n += n2) {
                n2 = this.in.read(byArray, n, byArray.length - n);
            }
            return n;
        }

        public void flush() throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                if (log.isErrorEnabled()) {
                    log.error("++++ attempting to write to closed socket");
                }
                throw new IOException("++++ attempting to write to closed socket");
            }
            this.out.flush();
        }

        public void write(byte[] byArray) throws IOException {
            if (this.sock == null || !this.sock.isConnected()) {
                if (log.isErrorEnabled()) {
                    log.error("++++ attempting to write to closed socket");
                }
                throw new IOException("++++ attempting to write to closed socket");
            }
            this.out.write(byArray);
        }

        public int hashCode() {
            return this.sock == null ? 0 : this.sock.hashCode();
        }

        public String toString() {
            return this.sock == null ? "" : this.sock.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.sock != null) {
                    if (log.isErrorEnabled()) {
                        log.error("++++ closing potentially leaked socket in finalize");
                    }
                    this.sock.close();
                    this.sock = null;
                }
            }
            catch (Throwable throwable) {
                if (log.isErrorEnabled()) {
                    log.error(throwable.getMessage(), throwable);
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

