
/**
 * 
 */
package centfor.session.tomcat;

import java.io.IOException;

import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.session.StandardSession;

import com.danga.MemCached.MemCachedClient;
import com.danga.MemCached.SockIOPool;

public class MemcachedManager extends StandardManager  {

	protected MemCachedClient mc = null;
    protected SockIOPool pool = null;
    //protected String sockPoolName = "snasessionsock";
    protected String serverlist = "127.0.0.1:11211";
    protected String snaidPerfix = "centfor";
    protected String snaidFlag = "true";
    public MemcachedManager() {
        super();
    }

    public Session findSession(String id) throws IOException {
        Session session = super.findSession(id);
        if (session == null && id != null) {
            try {
                Object sid = mc.get(this.getSnaidPerfix() + id);
                if (sid != null) {
                    session = createSession(id);
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return session;
    }

    public Session createSession(String sessionId) {
        Session session = super.createSession(sessionId);
        mc.set(this.getSnaidPerfix() + session.getId(), snaidFlag);
        return session;
    }

    protected StandardSession getNewSession() {
        return new MemcachedSession(this, mc);
    }

    protected void initPool() {
        try {
            if (pool == null) {
                try {
                    pool = SockIOPool.getInstance();
                    pool.setServers(serverlist.split(","));
                    pool.setInitConn(5);
                    pool.setMinConn(5);
                    pool.setMaxConn(50);
                    pool.setMaintSleep(30);
                    pool.setNagle(false);
                    pool.initialize();
                } catch (Exception ex) {
                    log.error("error:", ex);
                }
            }
        } catch (Exception ex) {
            log.error("error:", ex);
        }

        if (mc == null) {
            mc = new MemCachedClient();
          //  mc.
           // mc.setCompressEnable(false);
           // mc.setCompressThreshold(0);
        }
    }

    protected void closePool() {
        if (mc != null) {
            try {
            } catch (Exception ex) {
                log.error("error:", ex);
            }
            mc = null;
        }
        if (pool != null) {
            try {
                pool.shutDown();
            } catch (Exception ex) {
                log.error("error:", ex);
            }
        }
    }

   
    public String getServerlist() {
        return serverlist;
    }

    public String getSnaidPerfix() {
        return snaidPerfix;
    }

    public String getSnaidFlag() {
        return snaidFlag;
    }

  

    public void setServerlist(String serverlist) {
        this.serverlist = serverlist;
    }

    public void setSnaidPerfix(String snaidPerfix) {
        this.snaidPerfix = snaidPerfix;
    }

    public void setSnaidFlag(String snaidFlag) {
        this.snaidFlag = snaidFlag;
    }
/*
    protected String generateSessionId() {
        if (this.getJvmRoute() != null) {
            return java.util.UUID.randomUUID().toString() + '.' +
                    this.getJvmRoute();
        }
        return java.util.UUID.randomUUID().toString();
    }
*/
    public void start() throws LifecycleException {
        this.setPathname(""); // must disable session persistence across Tomcat restarts
        super.start();
        this.initPool();
    }

    public void stop() throws LifecycleException {
        super.stop();
        this.closePool();
    }
	
	
}
