package centfor.session.tomcat;

import com.danga.MemCached.*;
import org.apache.catalina.*;
import org.apache.catalina.session.StandardSession;

public class MemcachedSession extends StandardSession {
    /**
	 * 
	 */
	private static final long serialVersionUID = 2825587101107153818L;
	protected transient MemCachedClient mc = null;
    public MemcachedSession(Manager manager,
                            MemCachedClient mc) {
        super(manager);
        this.mc = mc;
    }


    public Object getAttribute(String name) {
        Object obj = super.getAttribute(name);
        if (obj != null && !(obj instanceof java.io.Serializable)) {
            return obj;
        }
        String key = name + this.getId();
        obj = mc.get(key);
        return obj;
    }

    public void setAttribute(String name, Object value) {
        removeAttribute(name);
        super.setAttribute(name, value);
        if (value != null && value instanceof java.io.Serializable) {
            String key = name + this.getId();
            mc.set(key, value);
        }
    }

    protected void removeAttributeInternal(String name, boolean notify) {
        super.removeAttributeInternal(name, notify);
        String key = name + this.getId();
        mc.delete(key);
    }

    public void expire(boolean notify) {
        mc.delete(((MemcachedManager) manager).getSnaidPerfix() + this.getId());
        super.expire(notify);
    }

}
